( function( $ ) {
    "use strict";
    var pxl_widget_countdown_handler = function( $scope, $ ) {
        $scope.find(".pxl-countdown").each(function () {
            var _this = $(this);
            var count_down = $(this).find('> div').data("count-down");
            setInterval(function () {
                var startDateTime = new Date().getTime();
                var endDateTime = new Date(count_down).getTime();
                var distance = endDateTime - startDateTime;
                var days = Math.floor(distance / (1000 * 60 * 60 * 24));
                var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                var seconds = Math.floor((distance % (1000 * 60)) / 1000);
                var text_day = days !== 1 ? _this.attr('data-days') : _this.attr('data-day');
                var text_hour = hours !== 1 ? _this.attr('data-hours') : _this.attr('data-hour');
                var text_minu = minutes !== 1 ? _this.attr('data-minutes') : _this.attr('data-minute');
                var text_second = seconds !== 1 ? _this.attr('data-seconds') : _this.attr('data-second');
                days = days < 10 ? '0' + days : days;
                hours = hours < 10 ? '0' + hours : hours;
                minutes = minutes < 10 ? '0' + minutes : minutes;
                seconds = seconds < 10 ? '0' + seconds : seconds;

                _this.html(''
                    + '<div class="countdown-item"><div class="countdown-item-inner"><svg xmlns="http://www.w3.org/2000/svg" width="146" height="146" viewBox="0 0 146 146" fill="none"><circle cx="73" cy="73" r="72.5" stroke="#20282D" stroke-opacity="0.39"/><mask id="path-2-inside-1_545_4907" fill="white"><path d="M146 73C146 91.33 139.104 108.989 126.683 122.469C114.261 135.948 97.2237 144.262 78.9548 145.757C60.6859 147.252 42.523 141.82 28.0752 130.539C13.6273 119.259 3.95194 102.956 0.971483 84.8698C-2.00898 66.7838 1.92364 48.2384 11.9879 32.9185C22.0522 17.5986 37.5116 6.62561 55.2942 2.17977C73.0769 -2.26608 91.8813 0.140647 107.971 8.92173C124.061 17.7028 136.258 32.2155 142.14 49.5763L141.199 49.8952C135.397 32.7708 123.366 18.4557 107.495 9.79412C91.6242 1.13258 73.0758 -1.24138 55.5353 3.14394C37.9947 7.52926 22.7459 18.3529 12.8186 33.4642C2.8913 48.5755 -0.987777 66.8684 1.95211 84.7082C4.89199 102.548 14.4357 118.629 28.6868 129.756C42.938 140.883 60.8535 146.241 78.8737 144.766C96.8939 143.291 113.7 135.091 125.952 121.795C138.204 108.499 145.006 91.0804 145.006 73H146Z"/></mask><path d="M146 73C146 91.33 139.104 108.989 126.683 122.469C114.261 135.948 97.2237 144.262 78.9548 145.757C60.6859 147.252 42.523 141.82 28.0752 130.539C13.6273 119.259 3.95194 102.956 0.971483 84.8698C-2.00898 66.7838 1.92364 48.2384 11.9879 32.9185C22.0522 17.5986 37.5116 6.62561 55.2942 2.17977C73.0769 -2.26608 91.8813 0.140647 107.971 8.92173C124.061 17.7028 136.258 32.2155 142.14 49.5763L141.199 49.8952C135.397 32.7708 123.366 18.4557 107.495 9.79412C91.6242 1.13258 73.0758 -1.24138 55.5353 3.14394C37.9947 7.52926 22.7459 18.3529 12.8186 33.4642C2.8913 48.5755 -0.987777 66.8684 1.95211 84.7082C4.89199 102.548 14.4357 118.629 28.6868 129.756C42.938 140.883 60.8535 146.241 78.8737 144.766C96.8939 143.291 113.7 135.091 125.952 121.795C138.204 108.499 145.006 91.0804 145.006 73H146Z" stroke="#20282D" stroke-width="2" mask="url(#path-2-inside-1_545_4907)"/></svg><div class="countdown-item-holder"><div class="countdown-amount">' + days + '</div><div class="countdown-period">' + text_day + '</div></div></div></div>'
                    + '<div class="countdown-item"><div class="countdown-item-inner"><svg xmlns="http://www.w3.org/2000/svg" width="146" height="146" viewBox="0 0 146 146" fill="none"><circle cx="73" cy="73" r="72.5" stroke="#20282D" stroke-opacity="0.39"/><mask id="path-2-inside-1_545_4903" fill="white"><path d="M146 73C146 85.3944 142.844 97.5847 136.83 108.422C130.816 119.26 122.141 128.387 111.624 134.945C101.107 141.503 89.0926 145.275 76.7143 145.905C64.336 146.536 52.0009 144.005 40.8715 138.55C29.7421 133.095 20.1849 124.896 13.1004 114.726C6.01597 104.556 1.63762 92.7492 0.377978 80.419C-0.881668 68.0888 1.01887 55.6409 5.90049 44.2484C10.7821 32.8558 18.4841 22.8938 28.2805 15.3011L28.8893 16.0866C19.2263 23.576 11.6292 33.4024 6.81401 44.6398C1.99885 55.8773 0.124187 68.1557 1.36668 80.318C2.60918 92.4803 6.92791 104.126 13.9159 114.158C20.9039 124.189 30.331 132.277 41.3089 137.657C52.2868 143.038 64.454 145.535 76.6637 144.913C88.8736 144.291 100.724 140.57 111.098 134.102C121.472 127.633 130.029 118.63 135.961 107.94C141.893 97.25 145.006 85.2256 145.006 73H146Z"/></mask><path d="M146 73C146 85.3944 142.844 97.5847 136.83 108.422C130.816 119.26 122.141 128.387 111.624 134.945C101.107 141.503 89.0926 145.275 76.7143 145.905C64.336 146.536 52.0009 144.005 40.8715 138.55C29.7421 133.095 20.1849 124.896 13.1004 114.726C6.01597 104.556 1.63762 92.7492 0.377978 80.419C-0.881668 68.0888 1.01887 55.6409 5.90049 44.2484C10.7821 32.8558 18.4841 22.8938 28.2805 15.3011L28.8893 16.0866C19.2263 23.576 11.6292 33.4024 6.81401 44.6398C1.99885 55.8773 0.124187 68.1557 1.36668 80.318C2.60918 92.4803 6.92791 104.126 13.9159 114.158C20.9039 124.189 30.331 132.277 41.3089 137.657C52.2868 143.038 64.454 145.535 76.6637 144.913C88.8736 144.291 100.724 140.57 111.098 134.102C121.472 127.633 130.029 118.63 135.961 107.94C141.893 97.25 145.006 85.2256 145.006 73H146Z" stroke="#20282D" stroke-width="2" mask="url(#path-2-inside-1_545_4903)"/></svg><div class="countdown-item-holder"><div class="countdown-amount">' + hours + '</div><div class="countdown-period">' + text_hour + '</div></div></div></div>'
                    + '<div class="countdown-item"><div class="countdown-item-inner"><svg xmlns="http://www.w3.org/2000/svg" width="146" height="146" viewBox="0 0 146 146" fill="none"><circle cx="73" cy="73" r="72.5" stroke="#20282D" stroke-opacity="0.39"/><mask id="path-2-inside-1_545_4907" fill="white"><path d="M146 73C146 91.33 139.104 108.989 126.683 122.469C114.261 135.948 97.2237 144.262 78.9548 145.757C60.6859 147.252 42.523 141.82 28.0752 130.539C13.6273 119.259 3.95194 102.956 0.971483 84.8698C-2.00898 66.7838 1.92364 48.2384 11.9879 32.9185C22.0522 17.5986 37.5116 6.62561 55.2942 2.17977C73.0769 -2.26608 91.8813 0.140647 107.971 8.92173C124.061 17.7028 136.258 32.2155 142.14 49.5763L141.199 49.8952C135.397 32.7708 123.366 18.4557 107.495 9.79412C91.6242 1.13258 73.0758 -1.24138 55.5353 3.14394C37.9947 7.52926 22.7459 18.3529 12.8186 33.4642C2.8913 48.5755 -0.987777 66.8684 1.95211 84.7082C4.89199 102.548 14.4357 118.629 28.6868 129.756C42.938 140.883 60.8535 146.241 78.8737 144.766C96.8939 143.291 113.7 135.091 125.952 121.795C138.204 108.499 145.006 91.0804 145.006 73H146Z"/></mask><path d="M146 73C146 91.33 139.104 108.989 126.683 122.469C114.261 135.948 97.2237 144.262 78.9548 145.757C60.6859 147.252 42.523 141.82 28.0752 130.539C13.6273 119.259 3.95194 102.956 0.971483 84.8698C-2.00898 66.7838 1.92364 48.2384 11.9879 32.9185C22.0522 17.5986 37.5116 6.62561 55.2942 2.17977C73.0769 -2.26608 91.8813 0.140647 107.971 8.92173C124.061 17.7028 136.258 32.2155 142.14 49.5763L141.199 49.8952C135.397 32.7708 123.366 18.4557 107.495 9.79412C91.6242 1.13258 73.0758 -1.24138 55.5353 3.14394C37.9947 7.52926 22.7459 18.3529 12.8186 33.4642C2.8913 48.5755 -0.987777 66.8684 1.95211 84.7082C4.89199 102.548 14.4357 118.629 28.6868 129.756C42.938 140.883 60.8535 146.241 78.8737 144.766C96.8939 143.291 113.7 135.091 125.952 121.795C138.204 108.499 145.006 91.0804 145.006 73H146Z" stroke="#20282D" stroke-width="2" mask="url(#path-2-inside-1_545_4907)"/></svg><div class="countdown-item-holder"><div class="countdown-amount">' + minutes + '</div><div class="countdown-period">' + text_minu + '</div></div></div></div>'
                    + '<div class="countdown-item"><div class="countdown-item-inner"><svg xmlns="http://www.w3.org/2000/svg" width="146" height="146" viewBox="0 0 146 146" fill="none"><circle cx="73" cy="73" r="72.5" stroke="#20282D" stroke-opacity="0.39"/><mask id="path-2-inside-1_545_4914" fill="white"><path d="M146 73C146 91.33 139.104 108.989 126.683 122.469C114.261 135.948 97.2237 144.262 78.9548 145.757C60.6859 147.252 42.523 141.82 28.0752 130.539C13.6273 119.259 3.95194 102.956 0.971483 84.8698C-2.00898 66.7838 1.92364 48.2384 11.9879 32.9185C22.0522 17.5986 37.5116 6.62561 55.2942 2.17977C73.0769 -2.26608 91.8813 0.140647 107.971 8.92173C124.061 17.7028 136.258 32.2155 142.14 49.5763L141.199 49.8952C135.397 32.7708 123.366 18.4557 107.495 9.79412C91.6242 1.13258 73.0758 -1.24138 55.5353 3.14394C37.9947 7.52926 22.7459 18.3529 12.8186 33.4642C2.8913 48.5755 -0.987777 66.8684 1.95211 84.7082C4.89199 102.548 14.4357 118.629 28.6868 129.756C42.938 140.883 60.8535 146.241 78.8737 144.766C96.8939 143.291 113.7 135.091 125.952 121.795C138.204 108.499 145.006 91.0804 145.006 73H146Z"/></mask><path d="M146 73C146 91.33 139.104 108.989 126.683 122.469C114.261 135.948 97.2237 144.262 78.9548 145.757C60.6859 147.252 42.523 141.82 28.0752 130.539C13.6273 119.259 3.95194 102.956 0.971483 84.8698C-2.00898 66.7838 1.92364 48.2384 11.9879 32.9185C22.0522 17.5986 37.5116 6.62561 55.2942 2.17977C73.0769 -2.26608 91.8813 0.140647 107.971 8.92173C124.061 17.7028 136.258 32.2155 142.14 49.5763L141.199 49.8952C135.397 32.7708 123.366 18.4557 107.495 9.79412C91.6242 1.13258 73.0758 -1.24138 55.5353 3.14394C37.9947 7.52926 22.7459 18.3529 12.8186 33.4642C2.8913 48.5755 -0.987777 66.8684 1.95211 84.7082C4.89199 102.548 14.4357 118.629 28.6868 129.756C42.938 140.883 60.8535 146.241 78.8737 144.766C96.8939 143.291 113.7 135.091 125.952 121.795C138.204 108.499 145.006 91.0804 145.006 73H146Z" stroke="#20282D" stroke-width="2" mask="url(#path-2-inside-1_545_4914)"/></svg><div class="countdown-item-holder"><div class="countdown-amount">' + seconds + '</div><div class="countdown-period">' + text_second + '</div></div></div></div>'
                );
            }, 100);
        });
    };

    $( window ).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/pxl_countdown.default', pxl_widget_countdown_handler );
    } );
} )( jQuery );