<?php if(isset($settings['pxl_awards']) && !empty($settings['pxl_awards']) && count($settings['pxl_awards'])): ?>
<div class="pxl-awards-wrap">
    <div class="pxl-content-awards pxl-content-awards1">
        <div class="pxl-awards-inner">
            <?php foreach ($settings['pxl_awards'] as $key => $value):
                $title = isset($value['title']) ? $value['title'] : '';
                $sub_title = isset($value['sub_title']) ? $value['sub_title'] : '';
                $number = isset($value['number']) ? $value['number'] : '';
                $link = isset($value['link']) ? $value['link'] : [];
                $link_url = isset($link['url']) ? $link['url'] : ''; ?>
                <div class="pxl--item" >
                    <?php if (!empty($link_url)): ?>
                        <a <?php echo function_exists('logiku_render_link_attributes') ? logiku_render_link_attributes($link) : 'href="'.esc_url($link_url).'"'; ?> class="pxl-item--holder">
                    <?php else: ?>
                        <div class="pxl-item--holder">
                    <?php endif; ?>
                        <div class="pxl-title--wrap">
                            <div class="pxl-item--title">
                                <div class="pxl-item--number"> <?php echo esc_html($number); ?> </div>
                                <div class="pxl-title"><?php echo esc_html($title); ?></div>
                            </div>
                        </div>
                        <div class="pxl-item--meta">
                            <div class="pxl-item--subtitle"> <?php echo esc_html($sub_title); ?> </div>
                        </div>
                        <div class="pxl-item-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="63" height="65" viewBox="0 0 63 65" fill="none">
                                <rect x="0.5" y="0.5" width="62" height="63.2857" stroke="#FA4729"/>
                                <path d="M39.4584 27.047C39.4843 26.5506 39.1029 26.1272 38.6065 26.1013L30.5175 25.6795C30.0211 25.6536 29.5977 26.035 29.5718 26.5314C29.5459 27.0278 29.9274 27.4511 30.4237 27.477L37.614 27.852L37.239 35.0422C37.2131 35.5386 37.5945 35.962 38.0909 35.9879C38.5873 36.0138 39.0107 35.6324 39.0365 35.136L39.4584 27.047ZM25.7148 38.5715L26.3172 39.2402L39.162 27.6688L38.5596 27.0001L37.9572 26.3314L25.1125 37.9029L25.7148 38.5715Z" fill="#FA4729"/>
                            </svg>
                        </div>
                    <?php if (!empty($link_url)): ?>
                        </a>
                    <?php else: ?>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>
<?php endif; ?>
