<div class="pxl-link-custom">
    <?php foreach ($settings['content'] as $key => $link) :
        $icon_key = $widget->get_repeater_setting_key('pxl_icon', 'icons', $key);
        $widget->add_render_attribute($icon_key, [
            'class' => $link['pxl_icon'],
            'aria-hidden' => 'true',
        ]);
        $link1 = isset($link['link_maps']) ? $link['link_maps'] : [];
        $link2 = isset($link['link_tel1']) ? $link['link_tel1'] : [];
        $link3 = isset($link['link_tel2']) ? $link['link_tel2'] : [];
        $active_cls = '';
        $text = $widget->parse_text_editor($link['maps']);
        $tel1 = !empty($link['tel']) ? $widget->parse_text_editor($link['tel']) : '';
        $tel2 = !empty($link['tel2']) ? $widget->parse_text_editor($link['tel2']) : '';
        ?>
        <div class="pxl-link-custom-inner">
            <div class="pxl-item--link <?php echo esc_attr($active_cls . ' ' . $settings['pxl_animate']); ?>">
                <div class="pxl-content-icon">
                    <?php if (!empty($link['pxl_icon']['value'])) : ?>
                        <?php \Elementor\Icons_Manager::render_icon($link['pxl_icon'], ['aria-hidden' => 'true'], 'i'); ?>
                    <?php endif; ?>
                </div>
                <div class="pxl-title">
                    <?php if (!empty($link['wg_title'])) : ?>
                        <?php echo pxl_print_html($widget->parse_text_editor($link['wg_title'])); ?>
                    <?php endif; ?>
                </div>
                <div class="pxl-content-maps">
                    <?php if (!empty($text)) : ?>
                        <div class="pxl-maps">
                            <a <?php echo logiku_render_link_attributes($link1); ?>>
                                <?php echo pxl_print_html($text); ?>
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="pxl-content-tel">
                    <?php if (!empty($tel1)) : ?>
                        <div class="pxl-tel1">
                            <a <?php echo logiku_render_link_attributes($link2); ?>>
                                <?php echo pxl_print_html($tel1); ?>
                            </a>
                        </div>
                    <?php endif; ?>
                    |
                    <?php if (!empty($tel2)) : ?>
                        <div class="pxl-tel2">
                            <a <?php echo logiku_render_link_attributes($link3); ?>>
                                <?php echo pxl_print_html($tel2); ?>
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    <?php endforeach; ?>
</div>
