<?php if(isset($settings['lists']) && !empty($settings['lists']) && count($settings['lists'])): ?>
    <div class="pxl-list-info <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
        <?php foreach ($settings['lists'] as $key => $value): 
            $link = isset($value['link']) ? $value['link'] : [];

            $link_key = $widget->get_repeater_setting_key('link', 'value', $key);
            if (!empty($link['url'])) {
                $widget->add_render_attribute($link_key, 'href', esc_url($link['url']));
                if (!empty($link['is_external'])) {
                    $widget->add_render_attribute($link_key, 'target', '_blank');
                }
                if (!empty($link['nofollow'])) {
                    $widget->add_render_attribute($link_key, 'rel', 'nofollow');
                }
            }
            $link_attributes = $widget->get_render_attribute_string($link_key);?>
            <div class="pxl--item">
                <?php if(!empty($value['content'])) : ?>
                    <div class="pxl-item--content">
                        <div class="info-title"><?php echo esc_html($value['label']); ?></div>
                        <a class="info-content" <?php echo implode( ' ', [ $link_attributes ] ); ?>>
                            <?php echo pxl_print_html($value['content'])?> 
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        <?php endforeach; ?>
    </div>
<?php endif; ?>