<div class="pxl-pricing pxl-pricing1">
    <div class="pricing-inner">
        <?php if (!empty($settings['popular'])) : ?>
            <div class="pxl-pricing--top ">
                <span><?php echo esc_html($settings['popular']); ?></span>
            </div>
        <?php endif; ?>
        <div class="pxl-pricing--title pxl-empty"><?php echo esc_html($settings['title']); ?></div>
        <div class="pxl-pricing--price">
            <span class="pxl-pricing--currency"><?php echo esc_html($settings['currency']); ?></span>
            <div class="price-meta">
                <span><?php echo esc_html($settings['price']); ?></span>
                <div class="pxl-item--time el-empty">/<?php echo pxl_print_html($settings['time']); ?></div>
            </div>
        </div>
        <div class="pxl-pricing--subtitle pxl-empty"><?php echo esc_html($settings['sub_title']); ?></div>
    </div>
    <?php if(isset($settings['feature']) && !empty($settings['feature']) && count($settings['feature'])): ?>
        <ul class="pxl-pricing--feature">
            <?php
                foreach ($settings['feature'] as $key => $link):
                    $feature_text = $widget->parse_text_editor( $link['feature_text'] );
                    $feature_active = $widget->parse_text_editor( $link['feature_active'] );  ?>
                    <li>
                        <svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15" fill="none">
                            <path d="M2.29101 6.9446C2.03213 6.94533 1.77875 7.01933 1.56018 7.15806C1.3416 7.29678 1.16677 7.49455 1.05591 7.7285C0.945044 7.96244 0.90268 8.22299 0.933718 8.48C0.964756 8.73701 1.06793 8.97999 1.23129 9.18081L4.71389 13.447C4.83806 13.6012 4.99723 13.7235 5.17817 13.8038C5.35912 13.8841 5.55661 13.9201 5.75425 13.9088C6.17697 13.8861 6.5586 13.66 6.80192 13.2882L14.0362 1.63743C14.0373 1.6355 14.0386 1.63356 14.0399 1.63166C14.1077 1.52744 14.0857 1.3209 13.9456 1.19115C13.9071 1.15552 13.8617 1.12814 13.8123 1.11071C13.7628 1.09328 13.7103 1.08616 13.658 1.08979C13.6057 1.09342 13.5546 1.10772 13.508 1.13181C13.4615 1.15591 13.4203 1.18929 13.3871 1.22989C13.3845 1.23308 13.3818 1.23623 13.3791 1.23932L6.08325 9.48251C6.05548 9.51388 6.02177 9.53942 5.98405 9.55765C5.94634 9.57588 5.90538 9.58643 5.86355 9.58869C5.82172 9.59095 5.77986 9.58488 5.7404 9.57083C5.70094 9.55678 5.66466 9.53502 5.63368 9.50683L3.21233 7.30339C2.96085 7.07286 2.63217 6.94486 2.29101 6.9446Z" fill="#1EAE98"/>
                        </svg>
                        <?php if($feature_active == 'no') { echo '<del>'; } ?>
                        <?php echo pxl_print_html($feature_text); ?>
                        <?php if($feature_active == 'no') { echo '</del>'; } ?>
                    </li>
            <?php endforeach; ?>
        </ul>
    <?php endif; ?>
    <?php if ( ! empty( $settings['btn_text'] ) ) {
        $widget->add_render_attribute( 'btn_link', 'href', $settings['btn_link']['url'] );

        if ( $settings['btn_link']['is_external'] ) {
            $widget->add_render_attribute( 'btn_link', 'target', '_blank' );
        }

        if ( $settings['btn_link']['nofollow'] ) {
            $widget->add_render_attribute( 'btn_link', 'rel', 'nofollow' );
        } ?>
        <div class="pxl-pricing--button">
            <a class="btn" <?php pxl_print_html($widget->get_render_attribute_string( 'btn_link' )); ?>>
                <span>
                    <?php echo esc_attr($settings['btn_text']); ?>
                </span>
                <i class="pxl-icon--default flaticon flaticon-up-right-arrow"></i>
            </a>
        </div>
    <?php } ?>
    <div class="pxl-pricing--text pxl-empty"><?php echo esc_html($settings['text']); ?></div>
</div>