<div class="pxl-pricing pxl-pricing2">
    <div class="pricing-inner">
        <?php if (!empty($settings['popular'])) : ?>
            <div class="pxl-pricing--top pxl-text-right">
                <span><?php echo esc_html($settings['popular']); ?></span>
            </div>
        <?php endif; ?>
        <div class="pxl-pricing--title pxl-empty"><?php echo esc_html($settings['title']); ?></div>
        <div class="pxl-pricing--subtitle pxl-empty"><?php echo esc_html($settings['sub_title']); ?></div>
        <div class="pxl-pricing--price">
            <span class="pxl-pricing--currency"><?php echo esc_html($settings['currency']); ?></span>
            <div class="price-meta">
                <span><?php echo esc_html($settings['price']); ?></span>
                <div class="pxl-item--time el-empty"><?php echo pxl_print_html($settings['time']); ?></div>
            </div>
        </div>
    </div>
    <div class="pxl-pricing--text pxl-empty"><?php echo esc_html($settings['text']); ?></div>
    <?php if(isset($settings['feature']) && !empty($settings['feature']) && count($settings['feature'])): ?>
        <ul class="pxl-pricing--feature">
            <?php
                foreach ($settings['feature'] as $key => $link):
                    $feature_text = $widget->parse_text_editor( $link['feature_text'] );
                    $feature_active = $widget->parse_text_editor( $link['feature_active'] );  ?>
                    <li>
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M10.0001 18.3337C5.39771 18.3337 1.66675 14.6027 1.66675 10.0003C1.66675 5.39795 5.39771 1.66699 10.0001 1.66699C14.6024 1.66699 18.3334 5.39795 18.3334 10.0003C18.3334 14.6027 14.6024 18.3337 10.0001 18.3337ZM9.16891 13.3337L15.0615 7.4411L13.883 6.26259L9.16891 10.9767L6.81192 8.61957L5.63341 9.79816L9.16891 13.3337Z" fill="#1EAE98"/>
                        </svg>
                        <?php if($feature_active == 'no') { echo '<del>'; } ?>
                        <?php echo pxl_print_html($feature_text); ?>
                        <?php if($feature_active == 'no') { echo '</del>'; } ?>
                    </li>
            <?php endforeach; ?>
        </ul>
    <?php endif; ?>
    <?php if ( ! empty( $settings['btn_text'] ) ) {
        $widget->add_render_attribute( 'btn_link', 'href', $settings['btn_link']['url'] );

        if ( $settings['btn_link']['is_external'] ) {
            $widget->add_render_attribute( 'btn_link', 'target', '_blank' );
        }

        if ( $settings['btn_link']['nofollow'] ) {
            $widget->add_render_attribute( 'btn_link', 'rel', 'nofollow' );
        } ?>
        <div class="pxl-pricing--button">
            <a class="btn" <?php pxl_print_html($widget->get_render_attribute_string( 'btn_link' )); ?>>
                <span>
                    <?php echo esc_attr($settings['btn_text']); ?>
                </span>
                <svg xmlns="http://www.w3.org/2000/svg" width="49" height="50" viewBox="0 0 49 50" fill="none">
                    <rect width="49" height="50" fill="#172864"/>
                    <path d="M30.8892 21.0469C30.915 20.5505 30.5336 20.1271 30.0373 20.1012L21.9482 19.6794C21.4519 19.6535 21.0285 20.0349 21.0026 20.5313C20.9767 21.0277 21.3581 21.451 21.8545 21.4769L29.0447 21.8519L28.6697 29.0421C28.6439 29.5385 29.0253 29.9619 29.5217 29.9878C30.018 30.0137 30.4414 29.6323 30.4673 29.1359L30.8892 21.0469ZM20 30L20.6024 30.6687L30.5928 21.6687L29.9904 21L29.388 20.3313L19.3976 29.3313L20 30Z" fill="white"/>
                </svg>
            </a>
        </div>
    <?php } ?>
</div>